// Auth Middlewares for Email/Password authentication (VPS deployment)
import type { Request, Response, NextFunction } from "express";

// Extend Express User type
declare global {
  namespace Express {
    interface User {
      id: string;
      email: string;
      role: "admin" | "student";
      firstName?: string;
      lastName?: string;
    }
  }
}

// Check if user is authenticated
export function isAuthenticated(req: Request, res: Response, next: NextFunction) {
  if (req.isAuthenticated && req.isAuthenticated()) {
    return next();
  }
  res.status(401).json({ message: "Não autenticado" });
}

// Check if user is admin
export function isAdmin(req: Request, res: Response, next: NextFunction) {
  if (!req.user) {
    return res.status(401).json({ message: "Não autenticado" });
  }
  
  if (req.user.role !== "admin") {
    return res.status(403).json({ message: "Acesso negado. Apenas administradores." });
  }
  
  next();
}
