import { createRoot } from "react-dom/client";
import App from "./App";
import "./index.css";

// Initialize theme before rendering
function initializeTheme() {
  const stored = localStorage.getItem("theme");
  const prefersDark = window.matchMedia && window.matchMedia("(prefers-color-scheme: dark)").matches;
  const isDark = stored ? stored === "dark" : prefersDark;
  
  const root = document.documentElement;
  if (isDark) {
    root.classList.add("dark");
  } else {
    root.classList.remove("dark");
  }
}

// Apply theme immediately
initializeTheme();

createRoot(document.getElementById("root")!).render(<App />);
