import { useMemo } from "react";
import { CKEditor } from "@ckeditor/ckeditor5-react";
import ClassicEditor from "@ckeditor/ckeditor5-build-classic";
import "@ckeditor/ckeditor5-build-classic/build/translations/pt-br";

interface RichTextEditorProps {
  value: string;
  onChange: (value: string) => void;
  placeholder?: string;
}

export function RichTextEditor({ value, onChange, placeholder }: RichTextEditorProps) {
  const editorConfiguration = useMemo(
    () => ({
      language: "pt-br",
      placeholder,
      toolbar: {
        shouldNotGroupWhenFull: true,
        items: [
          "heading",
          "|",
          "bold",
          "italic",
          "link",
          "bulletedList",
          "numberedList",
          "blockQuote",
          "insertTable",
          "undo",
          "redo",
        ],
      },
      table: {
        contentToolbar: ["tableColumn", "tableRow", "mergeTableCells"],
      },
    }),
    [placeholder],
  );

  return (
    <div className="border rounded-lg overflow-hidden bg-background">
      <CKEditor
        editor={ClassicEditor}
        data={value}
        config={editorConfiguration}
        onChange={(_, editor) => onChange(editor.getData())}
      />
    </div>
  );
}
