// Course Card Component - Layout simples com thumbnail
import { Play } from "lucide-react";
import { Card } from "@/components/ui/card";
import { Progress } from "@/components/ui/progress";
import type { Course } from "@shared/schema";

interface CourseCardProps {
  course: Course & { progressPercentage?: number };
  onClick?: () => void;
}

export function CourseCard({ course, onClick }: CourseCardProps) {
  // Priorizar thumbVisaoAluno (550x550) para visão do aluno, depois thumbnailUrl, depois base64
  const thumbnailUrl = course.thumbVisaoAluno 
    ? course.thumbVisaoAluno
    : course.thumbnailUrl 
    ? course.thumbnailUrl
    : course.thumbnail
    ? `data:${course.thumbnailMimeType || "image/jpeg"};base64,${course.thumbnail}`
    : null;

  return (
    <Card
      className="group relative overflow-hidden cursor-pointer transition-transform duration-200 hover:scale-[1.02] border-0 shadow-lg bg-transparent w-full"
      onClick={onClick}
      data-testid={`card-course-${course.id}`}
    >
      {/* Wrapper como na referência */}
      <div className="relative flex flex-col">
        {/* Thumbnail 550x550 (quadrada) - mantém proporção mas em card vertical */}
        <div className="aspect-square relative bg-muted w-full">
          {thumbnailUrl ? (
            <img
              src={thumbnailUrl}
              alt={course.title}
              className="w-full h-full object-cover"
            />
          ) : (
            <div className="w-full h-full flex items-center justify-center bg-gradient-to-br from-primary/20 to-primary/5">
              <Play className="w-16 h-16 text-primary/50" />
            </div>
          )}
        </div>
      </div>
    </Card>
  );
}
