 Portal de Cursos Online - Saberon

 Visão Geral

O Saberon é uma plataforma completa de cursos online desenvolvida com tecnologias modernas, oferecendo uma experiência diferenciada para estudantes e administradores. O sistema combina um portal visual inspirado no Netflix/Udemy para alunos com um painel administrativo robusto para gestão de conteúdo e dados.

 Características Principais

 Para Estudantes
- Dashboard Visual: Interface inspirada no Netflix com navegação intuitiva
- Player de Vídeo: Sistema de reprodução personalizado com controles avançados
- Progresso Automático: Acompanhamento de conclusão de aulas e módulos
- Certificados Digitais: Geração automática ao completar cursos
- Sistema de Pontos: Gamificação para engajamento dos alunos

 Para Administradores
- Painel Completo: Dashboard com métricas e analytics em tempo real
- Gestão de Cursos: Criação, edição e organização de conteúdo
- Gestão de Usuários: Controle total sobre alunos e permissões
- Relatórios de Vendas: Integração com webhooks de pagamento
- Suporte Técnico: Sistema de tickets e FAQ integrado

 Tecnologias Utilizadas

 Frontend
- React 18 - Biblioteca principal para interface
- TypeScript - Tipagem estática para maior confiabilidade
- Vite - Build tool moderno e rápido
- Tailwind CSS - Framework CSS utilitário
- Radix UI - Componentes acessíveis e customizáveis
- Wouter - Roteamento leve e performático
- React Query - Gerenciamento de estado do servidor
- Recharts - Biblioteca de gráficos e visualizações

 Backend
- Node.js - Runtime JavaScript
- Express.js - Framework web minimalista
- TypeScript - Tipagem estática no servidor
- Passport.js - Autenticação robusta
- Drizzle ORM - ORM moderno e type-safe
- PostgreSQL - Banco de dados relacional
- Multer - Upload de arquivos
- Bcrypt - Criptografia de senhas

 Infraestrutura
- PM2 - Gerenciador de processos em produção
- Apache - Servidor web com proxy reverso
- PostgreSQL - Banco de dados principal
- ESBuild - Bundling otimizado para produção

 Estrutura do Projeto

```
saberon/
├── client/                  Frontend React
│   ├── src/
│   │   ├── components/      Componentes reutilizáveis
│   │   ├── pages/           Páginas da aplicação
│   │   ├── hooks/           Custom hooks
│   │   └── lib/             Utilitários e configurações
├── server/                  Backend Express
│   ├── auth.ts             Configuração de autenticação
│   ├── routes.ts           Rotas da API
│   ├── storage.ts          Camada de acesso a dados
│   └── db.ts               Configuração do banco
├── shared/                  Código compartilhado
│   └── schema.ts           Schema do banco de dados
├── seed.ts                 Script de inicialização
└── build.sh                Script de build e deploy
```

 Instalação e Configuração

 Pré-requisitos
- Node.js 18+ 
- PostgreSQL 12+
- Apache 2.4+ (para produção)

 Configuração do Banco de Dados

```bash
 Instalar PostgreSQL
sudo apt update
sudo apt install postgresql postgresql-contrib

 Criar usuário e banco
sudo -u postgres psql
CREATE USER saberon WITH PASSWORD 'sua_senha';
CREATE DATABASE saberon_db OWNER saberon;
GRANT ALL PRIVILEGES ON DATABASE saberon_db TO saberon;
```

 Instalação do Projeto

```bash
 Clonar o repositório
git clone <url-do-repositorio>
cd saberon

 Instalar dependências
npm install

 Configurar variáveis de ambiente
cp .env.example .env
 Editar .env com suas configurações

 Configurar banco de dados
npm run db:push

 Executar seed inicial
npm run db:setup
```

 Scripts Disponíveis

```bash
 Desenvolvimento
npm run dev               Inicia servidor de desenvolvimento

 Build e Deploy
npm run build             Compila para produção
npm run start             Inicia servidor de produção
bash build.sh             Script completo de build e deploy

 Banco de Dados
npm run db:push           Aplica mudanças no schema
npm run db:setup          Configura banco e executa seed
```

 Configuração de Produção

 Apache Virtual Host

```apache
<VirtualHost *:80>
    ServerName seu-dominio.com
    ProxyPreserveHost On
    ProxyPass / http://localhost:3000/
    ProxyPassReverse / http://localhost:3000/
</VirtualHost>
```

 PM2 Ecosystem

```javascript
module.exports = {
  apps: [{
    name: 'saberon',
    script: 'dist/index.js',
    instances: 1,
    exec_mode: 'fork',
    env: {
      NODE_ENV: 'production',
      PORT: 3000
    }
  }]
};
```

 Sistema de Autenticação

 Usuário Admin Padrão
Após o build inicial, um usuário administrador é criado automaticamente:

- Email: `admin@saberon.com`
- Senha: `admin123`
- ⚠️ Importante: Altere a senha após o primeiro login!

 Personalização de Credenciais
Configure as credenciais do admin através de variáveis de ambiente:

```env
ADMIN_EMAIL=seu-email@exemplo.com
ADMIN_PASSWORD=sua-senha-segura
ADMIN_FIRST_NAME=Seu
ADMIN_LAST_NAME=Nome
```

 Funcionalidades Detalhadas

 Portal do Aluno

 Dashboard Principal
- Hero Banner: Curso em destaque com call-to-action
- Meus Cursos: Categorias organizadas (Em Andamento, Concluídos, Novos)
- Sistema de Busca: Pesquisa rápida por cursos e conteúdo
- Progresso Visual: Indicadores de conclusão e pontuação

 Player de Vídeo
- Controles Personalizados: Interface otimizada para educação
- Navegação Lateral: Estrutura do curso com módulos e aulas
- Progresso Automático: Salvamento automático do progresso
- Recursos Adicionais: Downloads de materiais e certificados

 Painel Administrativo

 Dashboard Executivo
- Métricas Principais: Total de alunos, certificados emitidos, acessos
- Gráficos de Crescimento: Evolução de alunos por mês
- Rankings: Top alunos por pontos e engajamento
- Analytics Avançados: Segmentação de acessos e comportamento

 Gestão de Conteúdo
- Criação de Cursos: Interface completa para upload e organização
- Upload de Mídia: Suporte a vídeos e PDFs em base64
- Estrutura Modular: Organização em módulos e aulas
- Controle de Status: Rascunho, publicado, arquivado

 Gestão de Usuários
- Lista Completa: Visualização de todos os usuários
- Filtros Avançados: Por role, curso, status
- Ações em Lote: Exportação e gerenciamento em massa
- Controle de Acesso: Permissões granulares por curso

 Relatórios de Vendas
- Integração Webhook: Recebimento automático de vendas
- Status de Pagamento: Processado, pendente, erro
- Relatórios Financeiros: Análise de receita e conversão
- Exportação de Dados: Relatórios em Excel/CSV

 Banco de Dados

 Schema Principal

 Tabelas de Usuários
- users: Dados dos usuários (alunos e admins)
- sessions: Sessões de autenticação
- userCourseAccess: Controle de acesso aos cursos

 Tabelas de Conteúdo
- courses: Informações dos cursos
- courseModules: Módulos de cada curso
- courseLessons: Aulas individuais
- courseMaterials: Materiais complementares (PDFs)

 Tabelas de Progresso
- studentProgress: Progresso individual por aula
- certificates: Certificados emitidos
- accessLogs: Logs de acesso para analytics

 Tabelas de Negócio
- sales: Vendas recebidas via webhook
- supportTickets: Sistema de suporte
- faqItems: Perguntas frequentes

 API Endpoints

 Autenticação
```
POST /api/login           Login de usuário
POST /api/register        Registro de usuário
POST /api/logout          Logout
GET  /api/me              Dados do usuário logado
```

 Admin - Cursos
```
GET    /api/admin/courses               Listar cursos
POST   /api/admin/courses               Criar curso
PUT    /api/admin/courses/:id           Atualizar curso
DELETE /api/admin/courses/:id           Deletar curso
```

 Admin - Dashboard
```
GET /api/admin/dashboard                Métricas do dashboard
GET /api/admin/users                    Listar usuários
GET /api/admin/sales                    Listar vendas
GET /api/admin/support/tickets          Tickets de suporte
GET /api/admin/faq                      Perguntas frequentes
```

 Aluno - Cursos
```
GET /api/courses                        Cursos disponíveis
GET /api/courses/:id                    Detalhes do curso
GET /api/courses/:id/progress           Progresso no curso
POST /api/courses/:id/enroll            Inscrever-se no curso
```

 Design System

 Paleta de Cores
- Background: `1a1a1a` (charcoal escuro)
- Surface: `262626` (superfícies elevadas)
- Primary: `3b82f6` (azul vibrante)
- Success: `10b981` (verde)
- Warning: `f59e0b` (laranja)
- Danger: `ef4444` (vermelho)

 Tipografia
- Primary: Inter (UI, texto)
- Display: Poppins (títulos)
- Monospace: JetBrains Mono (código, métricas)

 Componentes
- Cards: Bordas arredondadas, sombras sutis
- Botões: Estados hover e focus bem definidos
- Formulários: Validação em tempo real
- Tabelas: Alternância de cores, ordenação
- Gráficos: Tema customizado com cores da marca

 Segurança

 Autenticação
- Bcrypt: Hash seguro de senhas
- Sessions: Gerenciamento via PostgreSQL
- Middleware: Proteção de rotas administrativas
- CORS: Configuração adequada para produção

 Validação
- Zod: Validação de schemas no frontend e backend
- Sanitização: Limpeza de dados de entrada
- Rate Limiting: Proteção contra ataques de força bruta

 Upload de Arquivos
- Multer: Processamento seguro de uploads
- Validação: Tipos e tamanhos permitidos
- Armazenamento: Base64 no banco de dados

 Performance

 Frontend
- Code Splitting: Carregamento sob demanda
- Lazy Loading: Componentes carregados quando necessário
- Memoização: React.memo e useMemo para otimização
- Bundle Size: Análise e otimização contínua

 Backend
- Connection Pooling: Gerenciamento eficiente de conexões
- Query Optimization: Consultas otimizadas no banco
- Caching: Cache de consultas frequentes
- Compression: Gzip para assets estáticos

 Banco de Dados
- Índices: Otimização de consultas frequentes
- Relacionamentos: Estrutura normalizada
- Backup: Estratégia de backup automático

 Monitoramento

 Logs
- Console Logs: Desenvolvimento e debug
- Error Tracking: Captura de erros em produção
- Access Logs: Monitoramento de acessos
- Performance Metrics: Tempo de resposta e uso de recursos

 Health Checks
- Database: Verificação de conectividade
- API: Endpoints de status
- Uptime: Monitoramento de disponibilidade

 Deploy e Manutenção

 Build de Produção
```bash
 Executar build completo
bash build.sh

 O script executa:
 1. Para o PM2
 2. Instala dependências
 3. Compila frontend e backend
 4. Inicia aplicação
 5. Configura banco de dados
 6. Cria usuário admin
```

 Backup do Banco
```bash
 Backup completo
pg_dump -h localhost -U saberon saberon_db > backup_$(date +%Y%m%d).sql

 Restore
psql -h localhost -U saberon saberon_db < backup_20240101.sql
```

 Atualizações
```bash
 Atualizar código
git pull origin main

 Rebuild e restart
bash build.sh

 Verificar status
pm2 status
pm2 logs saberon
```

 Contribuição

 Estrutura de Commits
```
feat: nova funcionalidade
fix: correção de bug
docs: documentação
style: formatação
refactor: refatoração
test: testes
chore: manutenção
```

 Pull Requests
1. Fork do repositório
2. Branch feature: `git checkout -b feature/nova-funcionalidade`
3. Commit: `git commit -m "feat: adiciona nova funcionalidade"`
4. Push: `git push origin feature/nova-funcionalidade`
5. Abrir Pull Request

 Licença

Este projeto está licenciado sob a Licença MIT - veja o arquivo [LICENSE](LICENSE) para detalhes.

 Suporte

Para suporte técnico ou dúvidas:
- Email: suporte@saberon.com
- Documentação: Este README
- Issues: GitHub Issues

---

Desenvolvido com ❤️ para revolucionar a educação online
